/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.util;

import java.io.ByteArrayInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.nio.ByteBuffer;
import java.util.Enumeration;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import java.util.zip.DeflaterInputStream;
import org.apache.commons.lang.ArrayUtils;

public class GzipOnTheFlyInputStream
extends SequenceInputStream {
    private static final int GZIP_MAGIC_NUMBER = 35615;
    private static final byte[] GZIP_HEADER = new byte[]{31, -117, 8, 0, 0, 0, 0, 0, 0, 0};
    private static final int BUFFER_SIZE = 4096;

    public GzipOnTheFlyInputStream(final InputStream in) {
        super((Enumeration<? extends InputStream>)new Enumeration<InputStream>(){
            private final OnTheFlyCompressionStream compressionStream;
            private State state;
            {
                this.compressionStream = new OnTheFlyCompressionStream(new CRC32InputStream(in));
                this.state = State.HEADER;
            }

            @Override
            public boolean hasMoreElements() {
                return this.state != null;
            }

            @Override
            public InputStream nextElement() {
                switch (this.state) {
                    case HEADER: {
                        this.state = State.CONTENT;
                        return new ByteArrayInputStream(GZIP_HEADER);
                    }
                    case CONTENT: {
                        this.state = State.TRAILER;
                        return this.compressionStream;
                    }
                    case TRAILER: {
                        this.state = null;
                        return new ByteArrayInputStream(this.compressionStream.getGzipTrailer());
                    }
                }
                throw new IllegalStateException();
            }
        });
    }

    private static class OnTheFlyCompressionStream
    extends DeflaterInputStream {
        private final CRC32InputStream crcInputStream;

        public OnTheFlyCompressionStream(CRC32InputStream crcInputStream) {
            super(crcInputStream, new Deflater(-1, true), 4096);
            this.crcInputStream = crcInputStream;
        }

        public byte[] getGzipTrailer() {
            byte[] crcBytes = this.intToBytes((int)this.crcInputStream.getCrcValue());
            byte[] byteCountBytes = this.intToBytes((int)this.crcInputStream.getByteCount());
            return ArrayUtils.addAll((byte[])crcBytes, (byte[])byteCountBytes);
        }

        private byte[] intToBytes(int crc) {
            byte[] array = ByteBuffer.allocate(4).putInt(crc).array();
            ArrayUtils.reverse((byte[])array);
            return array;
        }

        @Override
        public void close() throws IOException {
            this.def.end();
            super.close();
        }
    }

    private static class CRC32InputStream
    extends FilterInputStream {
        private final CRC32 crc = new CRC32();
        private long bytes;

        protected CRC32InputStream(InputStream in) {
            super(in);
        }

        @Override
        public int read() throws IOException {
            int r = super.read();
            if (r > -1) {
                this.crc.update(r);
                ++this.bytes;
            }
            return r;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int read = super.read(b, off, len);
            if (read > -1) {
                this.crc.update(b, off, read);
                this.bytes += (long)read;
            }
            return read;
        }

        public long getByteCount() {
            return this.bytes;
        }

        public long getCrcValue() {
            return this.crc.getValue();
        }
    }

    private static enum State {
        HEADER,
        CONTENT,
        TRAILER;

    }
}

