/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.mr.cache;

import com.splunk.io.SearchMetricsReporter;
import com.splunk.io.SearchOutputStream;
import com.splunk.mr.SplunkMR;
import com.splunk.mr.cache.JobQueue;
import com.splunk.mr.cache.MapCache;
import com.splunk.mr.cache.PathAndPointer;
import com.splunk.mr.cache.compact.CacheCompaction;
import com.splunk.mr.cache.compact.CompactJob;
import com.splunk.mr.cache.compact.GroupedCompactionProcessor;
import com.splunk.mr.cache.delete.GroupedDeletionProcessor;
import com.splunk.mr.cache.integration.CacheKey;
import com.splunk.mr.cache.integration.CacheSplitListener;
import com.splunk.mr.cache.reporting.Report;
import com.splunk.util.LazySeq;
import com.splunk.util.PathGenerator;
import com.splunk.util.StrUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.log4j.Logger;

public class MapCaches {
    private static final Logger gLogger = Logger.getLogger(MapCaches.class);
    private final LazyMapCacheProvider caches;
    private final FileSystem fs;
    private GroupedCompactionProcessor smallCompactions;
    private GroupedCompactionProcessor largeCompactions;
    private ExecutorService threadPool;

    public MapCaches(MapCacheProvider cacheProvider, FileSystem fs) {
        this.caches = new LazyMapCacheProvider(cacheProvider);
        this.fs = fs;
    }

    public MapCaches setReadKeysPool(ExecutorService threadPool) {
        this.threadPool = threadPool;
        for (MapCache cache : this.caches.values()) {
            cache.setReadKeysPool(threadPool);
        }
        return this;
    }

    public FileSystem getFileSystem() {
        return this.fs;
    }

    public synchronized MapCache getMapCache(CacheKey cacheKey) {
        return this.caches.get(cacheKey);
    }

    public void initForSplit(CacheKey cacheKey) {
        this.getMapCache(cacheKey);
    }

    public boolean hasCompactedResult(CacheKey cacheKey) {
        return this.getMapCache(cacheKey).hasCompactedResult(cacheKey);
    }

    public boolean hasStagedResult(CacheKey cacheKey) {
        return this.getMapCache(cacheKey).hasStagedResult(cacheKey);
    }

    public PathAndPointer getCompactedPathAndPointer(CacheKey cacheKey) {
        return this.getMapCache(cacheKey).getCompactedPathAndPointer(cacheKey);
    }

    public JobQueue.CacheJob getStagedResult(CacheKey cacheKey) throws IOException {
        return this.getMapCache(cacheKey).getStagedResult(cacheKey);
    }

    public void flagCacheUpdate(CacheKey cacheKey) {
        this.getMapCache(cacheKey).flagCacheUpdate();
    }

    public void flagCacheUpdateAll() {
        for (MapCache m : this.caches.values()) {
            m.flagCacheUpdate();
        }
    }

    public void fetchCompactedResult(CacheKey cacheKey, SearchOutputStream out, ThreadPoolExecutor tpe, CacheSplitListener csl) {
        this.getMapCache(cacheKey).fetchCompactedResult(cacheKey, out, tpe, csl);
    }

    public void compactAllSync(ExecutorService compactionThreadPool, SearchMetricsReporter metrics) {
        GroupedCompactionProcessor small = new GroupedCompactionProcessor(compactionThreadPool);
        GroupedCompactionProcessor large = new GroupedCompactionProcessor(compactionThreadPool);
        this.doCompact(small, large, Integer.MAX_VALUE, metrics);
        small.awaitCompletion();
        large.awaitCompletion();
    }

    public void compact(ExecutorService compactionThreadPool, int limit, SearchMetricsReporter metrics) {
        if (this.smallCompactions == null) {
            this.smallCompactions = new GroupedCompactionProcessor(compactionThreadPool);
        }
        if (this.largeCompactions == null) {
            this.largeCompactions = new GroupedCompactionProcessor(compactionThreadPool);
        }
        this.doCompact(this.smallCompactions, this.largeCompactions, limit, metrics);
    }

    private void doCompact(GroupedCompactionProcessor smallCompactions, GroupedCompactionProcessor largeCompactions, int limit, SearchMetricsReporter metrics) {
        boolean small = this.isEnabled(SplunkMR.CONF_CACHE_COMPACT);
        boolean large = this.isEnabled(SplunkMR.CONF_CACHE_MERGE);
        for (Map.Entry<String, MapCache> e : this.caches.entrySet()) {
            if (small) {
                smallCompactions.offer(new CompactJob(e.getKey(), new CacheCompaction.Small(e.getValue(), metrics, limit)));
            }
            if (!large) continue;
            largeCompactions.offer(new CompactJob(e.getKey(), new CacheCompaction.Large(e.getValue(), metrics)));
        }
    }

    private boolean isEnabled(String confKey) {
        return StrUtil.parseBoolean(this.fs.getConf().get(confKey), true);
    }

    public void awaitCacheReading() {
        for (MapCache m : this.caches.values()) {
            m.awaitResultFetcher();
        }
    }

    public void awaitCompactions() {
        if (this.smallCompactions != null) {
            this.smallCompactions.awaitCompletion();
        }
        if (this.largeCompactions != null) {
            this.largeCompactions.awaitCompletion();
        }
    }

    public void ensureCacheInfoFile(CacheKey cacheKey) {
        try {
            this.getMapCache(cacheKey).ensureCacheInfoFile(cacheKey);
        }
        catch (IOException e) {
            gLogger.debug((Object)("Could not ensure that the cache info file exists. Reason: " + e));
        }
    }

    public static MapCaches create(FileSystem fs) {
        return new MapCaches(new MapCacheProvider(fs), fs);
    }

    @Deprecated
    public void deleteCachePaths(ExecutorService _pipeModePool, Map<String, Set<CacheKey>> pathsToDelete) {
        Map<MapCache, Set<String>> cachesToPaths = this.getCachesToPaths(pathsToDelete);
        GroupedDeletionProcessor deletionProcessor = new GroupedDeletionProcessor(_pipeModePool);
        for (Map.Entry<MapCache, Set<String>> e : cachesToPaths.entrySet()) {
            deletionProcessor.offer(e.getKey(), e.getValue());
        }
        deletionProcessor.awaitCompletion();
    }

    private Map<MapCache, Set<String>> getCachesToPaths(Map<String, Set<CacheKey>> pathsToDelete) {
        HashMap<MapCache, Set<String>> cachesToPaths = new HashMap<MapCache, Set<String>>();
        for (Map.Entry<String, Set<CacheKey>> e : pathsToDelete.entrySet()) {
            MapCache mapCache = this.getMapCache(e.getValue().iterator().next());
            if (!cachesToPaths.containsKey(mapCache)) {
                cachesToPaths.put(mapCache, new HashSet());
            }
            ((Set)cachesToPaths.get(mapCache)).add(e.getKey());
        }
        return cachesToPaths;
    }

    public Iterable<Report> probe(String ... summaryIds) throws IOException {
        final Iterator<FileStatus> cacheDirs = this.getCacheDirIterator(summaryIds);
        return new Iterable<Report>(){

            @Override
            public Iterator<Report> iterator() {
                return new CacheReportIterator(cacheDirs);
            }
        };
    }

    private Iterator<FileStatus> getCacheDirIterator(String ... summaryIds) {
        HashMap<Integer, PathFilter> filters = new HashMap<Integer, PathFilter>();
        int cacheDirLevels = 3;
        int indexLevel = 1;
        int md5HashIdLevel = 2;
        int bucketIdLevel = 3;
        filters.put(indexLevel, new DirFilter(this.fs));
        filters.put(md5HashIdLevel, new DirFilter(this.fs, this.getMd5edSummaryIds(summaryIds)));
        filters.put(bucketIdLevel, new DirFilter(this.fs));
        List<LazySeq<FileStatus>> chain = PathGenerator.chain(this.fs, SplunkMR.getTopLevelCacheDir(this.fs.getConf()), cacheDirLevels, filters);
        return chain.get(cacheDirLevels).iterator();
    }

    private List<String> getMd5edSummaryIds(String ... summaryIds) {
        ArrayList<String> md5edSummaryIds = new ArrayList<String>();
        for (String summaryId : summaryIds) {
            md5edSummaryIds.add(SplunkMR.md5SummaryId(summaryId));
        }
        return md5edSummaryIds;
    }

    public static class DirFilter
    implements PathFilter {
        private final List<String> acceptableDirNames;
        private final FileSystem fs;

        public DirFilter(FileSystem fs) {
            this(fs, null);
        }

        public DirFilter(FileSystem fs, List<String> acceptableDirNames) {
            this.fs = fs;
            this.acceptableDirNames = acceptableDirNames;
        }

        public boolean accept(Path path) {
            try {
                return this.fs.getFileStatus(path).isDir() && this.matchesEitherOfTheDirNames(path.getName());
            }
            catch (IOException e) {
                gLogger.debug((Object)("Exception when checking if file is directory: " + e + ". Ignoring path= " + path));
                return false;
            }
        }

        private boolean matchesEitherOfTheDirNames(String name) {
            if (this.acceptableDirNames == null || this.acceptableDirNames.isEmpty()) {
                return true;
            }
            for (String acceptableName : this.acceptableDirNames) {
                if (!name.equals(acceptableName)) continue;
                return true;
            }
            return false;
        }
    }

    public class CacheReportIterator
    implements Iterator<Report> {
        private final Iterator<FileStatus> cacheDirs;

        public CacheReportIterator(Iterator<FileStatus> cacheDirs) {
            this.cacheDirs = cacheDirs;
        }

        @Override
        public boolean hasNext() {
            return this.cacheDirs.hasNext();
        }

        @Override
        public Report next() {
            return this.createReport(MapCache.create(MapCaches.this.fs, this.cacheDirs.next().getPath()));
        }

        private Report createReport(MapCache mapCache) {
            Report report = new Report();
            Path cachePath = mapCache.getCachePath();
            report.set("splunk_server", "resides-in-hadoop");
            report.set("bucket_id", cachePath.getName());
            report.set("index", cachePath.getParent().getParent().getName());
            report.set("bucket_path", cachePath.toUri().getPath());
            try {
                mapCache.probe(report);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return report;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class LazyMapCacheProvider {
        private final MapCacheProvider cacheProvider;
        private final Map<String, MapCache> caches;

        public LazyMapCacheProvider(MapCacheProvider cacheProvider) {
            this.cacheProvider = cacheProvider;
            this.caches = new HashMap<String, MapCache>();
        }

        public MapCache get(CacheKey cacheKey) {
            String key = cacheKey.getIndex() + ":" + cacheKey.getSummaryId() + ":" + cacheKey.getBucketId();
            if (!this.caches.containsKey(key)) {
                this.caches.put(key, this.cacheProvider.getNew(cacheKey, MapCaches.this.threadPool));
            }
            return this.caches.get(key);
        }

        public Set<Map.Entry<String, MapCache>> entrySet() {
            return this.caches.entrySet();
        }

        public Collection<MapCache> values() {
            return this.caches.values();
        }
    }

    public static class MapCacheProvider {
        private FileSystem fs;

        public MapCacheProvider(FileSystem fs) {
            this.fs = fs;
        }

        public MapCache getNew(CacheKey cacheKey, ExecutorService threadPool) {
            Path cachedir = SplunkMR.getHDFSCacheDir(this.fs.getConf(), cacheKey);
            MapCache mapCache = MapCache.create(this.fs, cachedir);
            mapCache.setCacheInfoDir(SplunkMR.getHDFSCacheDirAtSummaryIdLevel(cachedir));
            if (threadPool != null) {
                mapCache.setReadKeysPool(threadPool);
            }
            return mapCache;
        }
    }
}

