/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.mr;

import com.splunk.mr.input.RegexPathFilter;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.log4j.Logger;

public class FileBasedHeartBeat
extends Thread {
    private static Logger gLogger = Logger.getLogger(FileBasedHeartBeat.class);
    public static final String HEARTBEAT_FILE_EXTENTION = ".hb";
    private Path _heartBeatPath = null;
    private long _startIndex = 0L;
    private boolean _stop = false;
    private FileSystem _fs = null;
    private long _heartBeatInterval = 6000L;
    private int _threshold = 10;
    private long _index = 0L;

    public FileBasedHeartBeat(Configuration conf, boolean overwrite) throws IOException {
        String path = conf.get("splunk.heartbeat.path");
        this._heartBeatInterval = conf.getLong("splunk.heartbeat.interval", this._heartBeatInterval);
        this._threshold = conf.getInt("splunk.heartbeat.threshold", this._threshold);
        if (path == null || path.trim().length() == 0) {
            throw new IllegalArgumentException("Invalid value for splunk.heartbeat.path. Value cannot be empty or null. Current path=" + path);
        }
        if (this._threshold < 1) {
            throw new IllegalArgumentException("Invalid value for splunk.heartbeat.threshold. Value must be > 0. Current value=" + this._threshold);
        }
        if (this._heartBeatInterval < 1000L) {
            throw new IllegalArgumentException("Invalid value for splunk.heartbeat.interval. Value must be >= 1000(ms). Current value=" + this._heartBeatInterval);
        }
        this._fs = FileSystem.get((Configuration)conf);
        this._heartBeatPath = new Path(path);
        if (!this._fs.exists(this._heartBeatPath)) {
            this._fs.mkdirs(this._heartBeatPath);
        }
        if (overwrite) {
            this._index = 0L;
            this._startIndex = 0L;
            this._fs.create(this.getHeartBeatPath(), overwrite).close();
        } else {
            this._startIndex = this._index = this.getIndex();
        }
        this.setName("FileBasedHeartBeat: " + path);
        this.setDaemon(true);
    }

    @Override
    public void run() {
        gLogger.info((Object)("starting hearbeat thread, path=" + this._heartBeatPath + ", interval=" + this._heartBeatInterval + ", _startIndex=" + this._startIndex + ", _index=" + this._index));
        while (!this._stop) {
            Path oldHeartBeatPath = this.getHeartBeatPath();
            ++this._index;
            Path newHeartBeatPath = this.getHeartBeatPath();
            try {
                long renameTime;
                long sleepTime;
                long startTime = System.currentTimeMillis();
                if (!this._fs.rename(oldHeartBeatPath, newHeartBeatPath)) {
                    --this._index;
                    if (!this._fs.exists(oldHeartBeatPath)) {
                        this.terminate();
                        gLogger.error((Object)("Failed to rename heartbeat file, heartbeat file does not exist. heartbeatFile=" + oldHeartBeatPath));
                        break;
                    }
                }
                if ((sleepTime = this._heartBeatInterval - (renameTime = System.currentTimeMillis() - startTime)) > 0L) {
                    Thread.sleep(sleepTime);
                    continue;
                }
                gLogger.warn((Object)"Filesystem rename operation took longer than the heartbeat interval.Please increase the value of splunk.heartbeat.interval so that MR job won't mistakenly think SH is dead and kill itself. In addition, you could also decrease the value of splunk.heartbeat.threshold to avoid slowing down the MR job reaction to a real SH dead situation");
            }
            catch (IOException e) {
                --this._index;
                gLogger.error((Object)String.format("Failed to rename heartbeat file from %s to %s: ", oldHeartBeatPath, newHeartBeatPath), (Throwable)e);
            }
            catch (InterruptedException e) {
                throw new RuntimeException("The sleep of FileBasedHeartBeat thread was interrupted", e);
            }
        }
        gLogger.info((Object)("stopping hearbeat thread, path=" + this._heartBeatPath + ", interval=" + this._heartBeatInterval + ", _startIndex=" + this._startIndex + ", _index=" + this._index));
    }

    public void terminate() {
        this._stop = true;
    }

    private long getIndex() throws IOException {
        FileStatus[] status = this._fs.listStatus(this._heartBeatPath, (PathFilter)new RegexPathFilter("\\.hb$"));
        if (status == null || status.length == 0) {
            return this._startIndex;
        }
        long maxIdx = Long.MIN_VALUE;
        long i = 0L;
        for (FileStatus s : status) {
            i = Long.parseLong(s.getPath().getName().split("\\.")[0]);
            if (i <= maxIdx) continue;
            maxIdx = i;
        }
        return maxIdx;
    }

    private Path getHeartBeatPath() {
        return new Path(this._heartBeatPath, this._index + HEARTBEAT_FILE_EXTENTION);
    }

    public boolean alive(long elapsedTime) throws IOException {
        if (this._stop) {
            return false;
        }
        if (elapsedTime < this._heartBeatInterval) {
            return true;
        }
        long currentIndex = this.getIndex();
        if (currentIndex == this._startIndex) {
            return true;
        }
        gLogger.info((Object)("elapsedTime=" + elapsedTime + ", heartBeatInterval=" + this._heartBeatInterval + ", threshold=" + this._threshold + ", _heartBeatPath=" + this._heartBeatPath + ", _startIndex=" + this._startIndex + ", currentIndex=" + currentIndex));
        long actualHeartBeats = currentIndex - this._startIndex;
        long expectedHeartBeats = elapsedTime / this._heartBeatInterval;
        long missedHeartBeats = expectedHeartBeats - actualHeartBeats;
        return missedHeartBeats < (long)this._threshold;
    }
}

