/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.roll;

import com.splunk.mr.cache.reporting.Report;
import com.splunk.roll.ArchivableBucketsFilter;
import com.splunk.roll.Bucket;
import com.splunk.roll.BucketLister;
import com.splunk.roll.PathResolver;
import com.splunk.roll.RollValidator;
import com.splunk.roll.RollerCli;
import com.splunk.roll.TempFileCleaner;
import com.splunk.roll.ThrottledIO;
import com.splunk.roll.Transactor;
import com.splunk.roll.slices.BucketRawdataProvider;
import com.splunk.roll.util.ConfU;
import com.splunk.roll.util.OutputUtil;
import com.splunk.util.FunctionUtils;
import com.splunk.util.MapUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.ParseException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.log4j.Logger;

public class Roller {
    public static final String BUCKETS_COPIED = "buckets_copied";
    public static final String BUCKETS_LISTED = "buckets_listed";
    public static final String BUCKETS_ALREADY_COPIED = "buckets_copied_from_before";
    public static final String BUCKETS_INVALID = "buckets_invalid";
    public static final String BUCKETS_FAILURES = "buckets_failed";
    public static final String FROZEN_BUCKETS_REMAINING = "buckets_to_freeze_remaining_count";
    public static final String FROZEN_BUCKETS_REMAINING_SIZE = "buckets_to_freeze_size_bytes";
    public static final String FROZEN_BUCKETS_DELETED = "buckets_to_freeze_deleted";
    public static final String FROZEN_BUCKETS_DELETED_SIZE = "buckets_to_freeze_deleted_size_bytes";
    private static final Logger gLogger = Logger.getLogger(Roller.class);
    private final Configuration conf;
    private final PathResolver pathResolver;
    private final BucketLister bucketLister;
    private final Transactor transactor;
    private final RollValidator rollValidator;
    private final TempFileCleaner tempFileCleaner;
    private final ArchivableBucketsFilter archivableBucketsFilter;

    public Roller(Configuration conf, PathResolver pathResolver, BucketLister bucketLister, Transactor transactor, RollValidator rollValidator, TempFileCleaner tempFileCleaner, ArchivableBucketsFilter archivableBucketsFilter) {
        this.conf = conf;
        this.pathResolver = pathResolver;
        this.bucketLister = bucketLister;
        this.transactor = transactor;
        this.rollValidator = rollValidator;
        this.tempFileCleaner = tempFileCleaner;
        this.archivableBucketsFilter = archivableBucketsFilter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Report copy() throws IOException {
        gLogger.info((Object)("About to remove temporary files before starting to copy buckets " + Roller.getRollRoute(this.conf)));
        this.cleanOldTemporaryFiles();
        long copyStartTime = System.currentTimeMillis();
        gLogger.info((Object)("STARTED to copy buckets " + Roller.getRollRoute(this.conf)));
        Report report = new Report();
        report.set("splunk_index", ConfU.getRollIndex(this.conf));
        report.set("virtual_index", ConfU.getRollVix(this.conf));
        report.increment(BUCKETS_LISTED, 0L);
        report.increment(BUCKETS_COPIED, 0L);
        report.increment(BUCKETS_ALREADY_COPIED, 0L);
        report.increment(BUCKETS_INVALID, 0L);
        try {
            for (Bucket.LocalBucket b : this.listBuckets()) {
                report.increment(BUCKETS_LISTED, 1L);
                gLogger.debug((Object)("Found local bucket=" + b));
                if (!this.shouldCopyBucket(report, b)) continue;
                this.doCopyBucket(report, b);
            }
        }
        finally {
            report.set("total_elapsed_ms", System.currentTimeMillis() - copyStartTime);
            this.logFrozenLeftOvers(report);
            this.logReport(report);
        }
        return report;
    }

    private boolean shouldCopyBucket(Report report, Bucket.LocalBucket b) throws IOException {
        try {
            if (!this.archivableBucketsFilter.isBucketArchivable(b)) {
                report.increment(BUCKETS_INVALID, 1L);
                gLogger.debug((Object)("Ignoring bucket=" + b + ", it was invalid"));
                return false;
            }
            Path remotePathOrNull = this.pathResolver.findBucket(this.conf, b);
            if (remotePathOrNull != null && this.rollValidator.isRollValid(remotePathOrNull, true)) {
                report.increment(BUCKETS_ALREADY_COPIED, 1L);
                gLogger.debug((Object)("Ignorning bucket=" + b + ", it had already been copied"));
                this.deleteIfBucketWasFrozen(b, report);
                return false;
            }
            return true;
        }
        catch (Exception e) {
            report.increment(BUCKETS_FAILURES, 1L);
            gLogger.error((Object)("Exception when deciding if bucket should be copied. " + b));
            return false;
        }
    }

    private void logFrozenLeftOvers(Report report) {
        try {
            List<File> frozenBuckets = this.bucketLister.listFrozenBuckets();
            report.set(FROZEN_BUCKETS_REMAINING, frozenBuckets.size());
            report.set(FROZEN_BUCKETS_REMAINING_SIZE, FunctionUtils.reduce(frozenBuckets, 0L, new FunctionUtils.RFn<File, Long>(){

                @Override
                public Long apply(Long results, File element) throws Exception {
                    return results + FileUtils.sizeOfDirectory((File)element);
                }
            }));
        }
        catch (Exception e) {
            gLogger.warn((Object)("Exception when logging frozen left overs. exception=" + e), (Throwable)e);
        }
    }

    private Iterable<Bucket.LocalBucket> listBuckets() {
        return new Iterable<Bucket.LocalBucket>(){

            @Override
            public Iterator<Bucket.LocalBucket> iterator() {
                return Roller.this.bucketLister.listBuckets();
            }
        };
    }

    private void logReport(Report report) throws IOException {
        OutputUtil.writeMap(gLogger, "FINISHED copying buckets. Report: ", report.toMap());
    }

    private void doCopyBucket(Report report, Bucket.LocalBucket b) throws IOException {
        try {
            Path remotePath = this.pathResolver.resolvePath(b);
            gLogger.info((Object)("Will try to copy bucket=" + b + " to remotePath=" + remotePath));
            this.transactor.prepare(b);
            gLogger.debug((Object)("Prepare transaction successful bucket=" + b));
            this.transactor.commit(b);
            report.increment(BUCKETS_COPIED, 1L);
            gLogger.info((Object)("Commit transaction successful bucket=" + b));
            OutputUtil.writeMap(gLogger, "Done copying bucket", MapUtil.asMap("bucket", b.toString(), "remotePath", remotePath.toString()), true);
            if (this.rollValidator.isRollValid(remotePath, false)) {
                this.deleteIfBucketWasFrozen(b, report);
            }
        }
        catch (Transactor.S3ConsistencyModelException e) {
            gLogger.debug((Object)e.getMessage());
        }
        catch (Transactor.AlreadyCopiedBucketException e) {
            gLogger.info((Object)e.getMessage());
        }
        catch (BucketRawdataProvider.CouldNotReadMetadataFromClusteredBucket e) {
            gLogger.warn((Object)e.getMessage());
        }
        catch (Exception e) {
            this.outputThrowable(report, b, e);
            if (e instanceof IOException) {
                throw (IOException)e;
            }
        }
        catch (Error e) {
            this.outputThrowable(report, b, e);
            throw e;
        }
        finally {
            try {
                this.transactor.clean(b);
            }
            catch (Exception e) {
                gLogger.error((Object)("Error when cleaning transaction bucket=" + b + ", ignoring"));
            }
            try {
                this.transactor.fillReport(report, b);
            }
            catch (Exception e) {
                gLogger.error((Object)("Exception when gathering transaction report for bucket=" + b));
            }
        }
    }

    private void deleteIfBucketWasFrozen(Bucket.LocalBucket b, Report report) {
        File bucketDir = b.getDir();
        if (BucketLister.hasFrozenPrefix(bucketDir)) {
            long sizeOfDirectory = this.getSizeOfDirectoryOrZero(bucketDir);
            boolean delete = FileUtils.deleteQuietly((File)bucketDir);
            if (delete) {
                report.increment(FROZEN_BUCKETS_DELETED, 1L);
                report.increment(FROZEN_BUCKETS_DELETED_SIZE, sizeOfDirectory);
                gLogger.info((Object)("Deleted frozen bucket " + b));
            } else {
                boolean exists = b.exists();
                if (exists) {
                    gLogger.error((Object)("Tried to delete a frozen bucket but couldn't. It still exists. The disk may fill up if this continues to happen. Make sure permissions are setup so that the buckets can get deleted. " + b));
                }
            }
        }
    }

    private long getSizeOfDirectoryOrZero(File bucketDir) {
        try {
            return FileUtils.sizeOfDirectory((File)bucketDir);
        }
        catch (Exception ignore) {
            return 0L;
        }
    }

    private void outputThrowable(Report report, Bucket.LocalBucket b, Throwable e) {
        report.increment(BUCKETS_FAILURES, 1L);
        try {
            OutputUtil.writeMap(gLogger, e, "Error when doing roll transaction: ", MapUtil.asMap("roll_route", Roller.getRollRoute(this.conf), "bucket", b.getName(), "exception", e.getMessage()));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void cleanOldTemporaryFiles() {
        try {
            this.tempFileCleaner.clean(this.transactor.listLocalTempFiles());
            this.tempFileCleaner.clean(this.transactor.listRemoteTempFiles());
        }
        catch (Exception e) {
            gLogger.warn((Object)("Exception=" + e + ", when cleaning temporary files. Ignoring and moving on."));
        }
    }

    public static String getRollRoute(Configuration conf) {
        String vix = ConfU.getRollVix(conf);
        String index = ConfU.getRollIndex(conf);
        return " from splunk_index=" + index + ", to virtual_index=" + vix;
    }

    public static Roller create(Configuration conf, ThrottledIO throttledIO) {
        return Roller.create(conf, ConfU.getRollLocalHome(conf), ConfU.getBucketDirs(conf), throttledIO);
    }

    static Roller create(Configuration conf, File hunkRollTempDir, List<File> bucketDirs, ThrottledIO throttledIO) {
        return Roller.create(conf, hunkRollTempDir, bucketDirs, throttledIO, ArchivableBucketsFilter.create(conf));
    }

    static Roller create(Configuration conf, File hunkRollTempDir, List<File> bucketDirs, ThrottledIO throttledIO, ArchivableBucketsFilter archivableBucketsFilter) {
        Roller.ensureDirExistence(hunkRollTempDir);
        BucketLister bucketLister = BucketLister.create(conf, bucketDirs);
        PathResolver pathResolver = PathResolver.create(conf);
        RollValidator rollValidator = RollValidator.create(conf);
        Transactor transactor = Transactor.create(conf, pathResolver, hunkRollTempDir, rollValidator, throttledIO);
        return new Roller(conf, pathResolver, bucketLister, transactor, rollValidator, new TempFileCleaner(conf, ConfU.getStaleTempFilesTimeout(conf)), archivableBucketsFilter);
    }

    public static void ensureDirExistence(File dir) {
        dir.mkdirs();
        if (!dir.exists()) {
            throw new RuntimeException("Could not setup dir=" + dir);
        }
    }

    public static void main(String[] args) throws IOException {
        try {
            RollerCli cli = RollerCli.create(args);
            Configuration conf = cli.getConf();
            ThrottledIO io = ThrottledIO.create(conf).start();
            Roller roller = Roller.create(conf, io);
            roller.copy();
        }
        catch (ParseException e) {
            Roller.printUsage();
            System.out.println("\nFailure java exception:\n" + (Object)((Object)e));
            System.exit(1);
        }
    }

    private static void printUsage() {
        HelpFormatter helpFormatter = new HelpFormatter();
        helpFormatter.setNewLine("\n");
        String header = "Hunk roll utility\n\nAll undefined key value pairs will be added to the Hadoop Configuration object. You can use these key values to set any Hadoop setting.";
        String footer = "";
        helpFormatter.printHelp(Roller.getUsage() + " [[key value] ...]", header, RollerCli.options, footer);
    }

    private static String getUsage() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintWriter baosPrinter = new PrintWriter(baos);
        new HelpFormatter().printUsage(baosPrinter, 74, "java -classpath <classpath> " + Roller.class.getName(), RollerCli.options);
        baosPrinter.close();
        String usage = new String(baos.toByteArray());
        usage = StringUtils.removeStart((String)usage, (String)"usage: ");
        usage = StringUtils.removeEnd((String)usage, (String)"\n");
        return usage;
    }
}

