/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.mr.cache.merge;

import com.splunk.mr.cache.CacheMerger;
import java.io.IOException;
import java.util.Set;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.log4j.Logger;

public class MergeDeleter {
    private static final Logger gLogger = Logger.getLogger(MergeDeleter.class);
    private final FileSystem fs;
    private final Path mergeDir;

    public MergeDeleter(FileSystem fs, Path mergeDir) {
        this.fs = fs;
        this.mergeDir = mergeDir;
    }

    public void delete(Set<CacheMerger.Mergee> merge) {
        for (CacheMerger.Mergee m : merge) {
            this.deleteMergee(m);
        }
    }

    public void deleteMergee(CacheMerger.Mergee m) {
        try {
            this.fs.delete(this.getChildOfMergeDir(m.path), true);
        }
        catch (IOException e) {
            gLogger.error((Object)("Could not delete path: " + m.path + " and will take up space until is deleted. Exception: " + e.getClass() + ":\"" + e.getMessage() + "\""));
        }
    }

    private Path getChildOfMergeDir(Path path) {
        Path parent = path.getParent();
        if (this.isRoot(parent)) {
            throw new IllegalMergePathException();
        }
        if (this.isEqual(parent, this.mergeDir)) {
            return path;
        }
        return this.getChildOfMergeDir(parent);
    }

    private boolean isRoot(Path parent) {
        return parent == null;
    }

    private boolean isEqual(Path p1, Path p2) {
        return p1.toUri().getPath().equals(p2.toUri().getPath());
    }

    public static void delete(FileSystem fs, Path mergeDir, CacheMerger.Mergee m) {
        new MergeDeleter(fs, mergeDir).deleteMergee(m);
    }

    public static class IllegalMergePathException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
    }
}

